% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/postproc.R
\name{postproc}
\alias{postproc}
\alias{postproc<-}
\title{Attach postprocessing function to operator}
\usage{
postproc(op)

postproc (op) <- value
}
\arguments{
\item{op}{the operator (function)}

\item{value}{function (or its name or symbol) to do the post-processing. \code{NULL} deletes the
postprocessing function.}
}
\value{
logical indicating the type of operator. \code{NA} if the attribute is missing.
}
\description{
The postprocessing function is applied during performance calculation after averaging but before
\code{\link{dev}} is applied. This is the place where the root is taken of root mean squared errors.
}
\details{
\code{postproc (op)} retrieves the postprocessing function (or \code{NULL} if none is attached)
}
\examples{
postproc (wRMSE)
myop <- function (r, p) p * (r == 1)
postproc (myop) <- `sqrt`
}
\author{
Claudia Beleites
}
\seealso{
\code{\link{sens}} \code{\link{post}}
}

