% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SDA_metrics.R
\name{get_SDA_metrics}
\alias{get_SDA_metrics}
\title{Get Soil Data Access, Lab Data Mart and Web Soil Survey Usage Metrics}
\usage{
get_SDA_metrics(query_name, query_frequency, query_year, state = NULL)
}
\arguments{
\item{query_name}{One or more of: \code{'LDM_Usage'}, \code{'SDA_Usage'}, \code{'wss_ActivityCounts'}, \code{'wss_AOIDefinition'}, \code{'wss_AOISizeRange'}, \code{'wss_ExportCounts'}, \code{'wss_PrintableOutput'}, \code{'wss_top100AOIs'}, \code{'wss_top100Ecologicalsites'}, \code{'wss_top100ratings'}, \code{'wss_top100reports'}}

\item{query_frequency}{One or more of: \code{'M'}, \code{'CY'}, \code{'FY'}}

\item{query_year}{Integer. One or more years e.g. \code{2020:2021}}

\item{state}{Optional: State abbreviation; Default: \code{NULL} uses \code{"xnational"} for all states.}
}
\value{
A \code{data.frame} containing query results
}
\description{
Obtain pre-calculated tabular reports of usage, activities, areas of interest (AOI), exports, ecological sites, ratings and reports for specific areas, times and intervals.
}
\examples{
\dontrun{
get_SDA_metrics('SDA_Usage', 'CY', 2019:2021)
}
}
\author{
Jason Nemecek
}
