% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\name{dat30}
\alias{dat30}
\alias{genocovdat30}
\alias{mapdat30}
\title{dat30 data set adapted from multic R package}
\format{(Phenotypes) A data frame \code{dat30} with 174 rows and 10 variables:
\describe{
  \item{famid}{Family ID (29 unique ids).}
  \item{id}{Individual ID.}
  \item{fa}{Father ID.}
  \item{mo}{Mother ID.}
  \item{sex}{Individual gender (1 - male, 2 - female).}
  \item{affect}{Affected status (1 - unaffected, 2 - affected).}
  \item{class}{Class label.}
  \item{trait1}{Simulated phenotype 1.}
  \item{trait2}{Simulated phenotype 2.}
  \item{age}{Age.}
}

(Genotypes as covariates) A matrix \code{genocovdat30} with 174 rows and 100 columns.
Row names are IDs of individuals, column names are names of SNPs.

(Annotation) A data frame \code{mapdat30} with 100 rows and 4 variables:
\describe{
  \item{SNP}{SNP name.}
  \item{chr}{Chromosome.}
  \item{pos}{Position in bp.}
  \item{gene}{Gene.}
}}
\source{
\url{https://cran.r-project.org/package=multic}
}
\description{
29 first families were selected from the complete data set of 12000 individuals.
For a resulted subset of 174 individuals,
a hundred of synthetic SNPs were randomly generated.
Annotation information also was generated,
mainly in order to plot the association results with Manhattan plot.
}
\details{
Two simulated phenotypes possess a high genetic correlation.
}
\examples{
data(dat30)

str(dat30)

plotPed(dat30, 2) # plot the pedigree tree for family #2

\dontrun{
kin2 <- solarKinship2(dat30)
plotKinship2(kin2)
plotKinship2(kin2[1:30, 1:30])

}
str(genocovdat30)

genocovdat30[1:5, 1:5]
str(mapdat30)

head(mapdat30)
}

