% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminal_nodes.R
\name{terminalNodesDepthPerTree}
\alias{terminalNodesDepthPerTree}
\title{Depth of each terminal node of a single tree in a ranger model}
\usage{
terminalNodesDepthPerTree(treelike)
}
\arguments{
\item{treelike}{Output of `ranger::treeInfo`}
}
\value{
data.table with two columns: id_node and depth
}
\description{
Depth of each terminal node of a single tree in a ranger model.
  Note that root node has the id_node = 0.
}
\examples{
\dontrun{
  rf = ranger::ranger(Species ~ ., data = iris)
  terminalNodesDepthPerTree(ranger::treeInfo(rf, 1))
}
}
