% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/regression_plot.R
\name{regression_plot}
\alias{regression_plot}
\alias{vwReg}
\title{Description: Draw regression curve with smoothed error bars
based on the Visually-Weighted Regression by Solomon M. Hsiang; see
http://www.fight-entropy.com/2012/07/visually-weighted-regression.html
The R implementation is based on Felix Schonbrodt's code from
http://www.nicebread.de/visually-weighted-watercolor-plots-new-variants-please-vote/}
\usage{
regression_plot(formula, data, main = NULL, B = 1000, shade = TRUE,
  shade.alpha = 0.1, spag = FALSE, mweight = TRUE, show.lm = FALSE,
  show.median = TRUE, median.col = "white", show.CI = FALSE,
  method = loess, bw = FALSE, slices = 200,
  palette = colorRampPalette(c("#FFEDA0", "#DD0000"), bias = 2)(20),
  ylim = NULL, quantize = "continuous", ...)
}
\arguments{
\item{formula}{formula}

\item{data}{data}

\item{main}{figure title}

\item{B}{number bootstrapped smoothers}

\item{shade}{plot the shaded confidence region?}

\item{shade.alpha}{shade.alpha: should the CI shading fade out at
       the edges? (by reducing alpha; 0 = no alpha decrease,
      0.1 = medium alpha decrease, 0.5 = strong alpha decrease)}

\item{spag}{plot spaghetti lines?}

\item{mweight}{should the median smoother be visually weighted?}

\item{show.lm}{should the linear regresison line be plotted?}

\item{show.median}{show median smoother}

\item{median.col}{median color}

\item{show.CI}{should the 95\% CI limits be plotted?}

\item{method}{the fitting function for the spaghettis; default: loess}

\item{bw}{define a default b/w-palette (TRUE/FALSE)}

\item{slices}{number of slices in x and y direction for the shaded
  region. Higher numbers make a smoother plot, but takes longer to
  draw. I wouldn'T go beyond 500}

\item{palette}{provide a custom color palette for the watercolors}

\item{ylim}{restrict range of the watercoloring}

\item{quantize}{either "continuous", or "SD". In the latter case,
  we get three color regions for 1, 2, and 3 SD (an idea of John Mashey)}

\item{...}{further parameters passed to the fitting function,
    in the case of loess, for example, "span = .9", or
    "family = 'symmetric'"

Returns:}
}
\value{
ggplot2 object
}
\description{
Arguments:
}
\examples{
\dontrun{library(dplyr); library(RColorBrewer);
  	     	      library(ggplot2); data(iris);
		      p <- regression_plot(Sepal.Length ~ Sepal.Width, iris)}
}
\author{
Based on the original version from Felix Schonbrodt.
        Modified by Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\references{
See citation("microbiome")
}
\keyword{utilities}

