#' sotu: State of the Union Addresses
#'
#' The President of the United States is constitutionally
#' obligated to provide a report of the current state of
#' country. While historically this could be a written
#' document, in modern times this has always taken the
#' form of an oral address to a joint session of the
#' US Congress. This package provides the raw text from
#' every State of the Union address, with the intention
#' of being used for meaningful examples of text analysis
#' in R. This corpus is well-suited to the task as a it
#' historically important, includes both material intended
#' to be read and material intended to be spoken, and it
#' falls in the public domain. As the corpus spans over
#' two centuries it is also a good test of how well various
#' methods hold up to the idiosyncrasies of historical texts.
#'
#' A metadata table containing information about each speech
#' is also included in the package. This includes information
#' about the date and president giving the address. Note that
#' some of the addresses contained in the archive are not
#' technically State of the Union Addresses, but are more
#' general Addresses to a Joint Session of Congress. Usually
#' these occur following a new president's inauguration, and
#' are historically treated as no different than a standard
#' State of the Union.
#'
#' @docType package
"_PACKAGE"

