% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{summary.soundcorrs}
\alias{summary.soundcorrs}
\title{Generate a segment-to-segment contingency table for two languages.}
\usage{
\method{summary}{soundcorrs}(object, count = "a", unit = "w", ...)
}
\arguments{
\item{object}{[soundcorrs] The dataset from which to draw frequencies. Only datasets with two languages are supported.}

\item{count}{[character] Report either the absolute or the relative numbers?. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs? Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}

\item{...}{Unused; only for consistency with \code{base::\link{summary}}.}
}
\value{
[table] The contingency table. The values represent how often the given segments correspond to each other, not how often they co-occur in the same word (cf. \code{\link{coocc}}).
}
\description{
Produce a contingency table detailing all segment-to-segment correspondences in a dataset.
}
\details{
A set of segmented and aligned word pairs/triples/..., such as one held in a \code{\link{soundcorrs}} object, can be turned into a contingency table in more than one way. Perhaps the simplest option is to see how often various segments from one language correspond to various segments from another language, which is the kind of table this function produces. Correspondences can be reported in absolute or relative numbers, and can represent the number of times the given correspondence occurs, or in how many words it occurs (the same correspondence can occur more than once in a single pair/triple/... of words, e.g. in German koala : French koala, the correspondence G a : Fr a occurs twice). When the numbers are relative, each row in the table adds up to 1. In theory, \code{summary.soundcorrs} can support a \code{\link{soundcorrs}} objects with any number of languages in it, but the legibility of the output drops very quickly when that number exceeds two.
}
\examples{
dataset <- loadSampleDataset ("data-ie")
summary (dataset)
round (summary(dataset,count="r"), digits=3)
summary (dataset, unit="o")
}
\seealso{
\code{\link{coocc}}
}
