% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{flatSpectrum}
\alias{flatSpectrum}
\title{Flat spectrum}
\usage{
flatSpectrum(x, freqWindow = NULL, samplingRate = NULL,
  dynamicRange = 80, windowLength = 50, step = NULL, overlap = 90,
  wn = "gaussian", zp = 0)
}
\arguments{
\item{x}{path to a .wav or .mp3 file or a vector of amplitudes with specified
samplingRate}

\item{freqWindow}{the width of smoothing window, Hz. Defaults to median
pitch estimated by \code{\link{analyze}}}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than an audio file)}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}
}
\value{
Returns a numeric vector with the same sampling rate as the input.
}
\description{
Flattens the spectrum of a sound by smoothing in the frequency domain. Can be
used for removing formants without modifying pitch contour or voice quality
(the balance of harmonic and noise components), followed by the addition of a
new spectral envelope (cf. \code{\link{transplantFormants}}). Algorithm:
makes a spectrogram, flattens the real part of the smoothed spectrum of each
STFT frame, and transforms back into time domain with inverse STFT (see also
\code{\link{addFormants}}).
}
\examples{
sound_aii = soundgen(formants = 'aii')
# playme(sound_aii, 16000)
seewave::meanspec(sound_aii, f = 16000, dB = 'max0')

sound_flat = flatSpectrum(sound_aii, freqWindow = 150, samplingRate = 16000)
# playme(sound_flat, 16000)
seewave::meanspec(sound_flat, f = 16000, dB = 'max0')
# harmonics are still there, but formants are gone and can be replaced

\dontrun{
# Now let's make a sheep say "aii"
data(sheep, package = 'seewave')  # import a recording from seewave
sheep_orig = as.numeric(scale(sheep@left))
samplingRate = sheep@samp.rate
playme(sheep_orig, samplingRate)
# spectrogram(sheep_orig, samplingRate)
# seewave::spec(sheep_orig, f = samplingRate, dB = 'max0')

sheep_flat = flatSpectrum(sheep_orig, freqWindow = 150,  # freqWindow ~f0
  samplingRate = samplingRate)
# playme(sheep_flat, samplingRate)
# spectrogram(sheep_flat, samplingRate)
# seewave::spec(sheep_flat, f = samplingRate, dB = 'max0')

# So far we have a sheep bleating with a flat spectrum;
# now let's add new formants
sheep_aii = addFormants(sheep_flat,
  samplingRate = samplingRate,
  formants = 'aii',
  lipRad = -3)  # negative lipRad to counter unnatural flat source
playme(sheep_aii, samplingRate)
# spectrogram(sheep_aii, samplingRate)
# seewave::spec(sheep_aii, f = samplingRate, dB = 'max0')
}
}
\seealso{
\code{\link{addFormants}} \code{\link{transplantFormants}}
}
