% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{.bandpass}
\alias{.bandpass}
\title{Bandpass filter per sound}
\usage{
.bandpass(
  audio,
  lwr,
  upr,
  action = c("pass", "stop")[1],
  dB = Inf,
  na.rm = TRUE,
  normalize = FALSE,
  plot = FALSE,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{lwr}{cutoff frequencies, Hz. Specifying just lwr gives a low-pass
filter, just upr high-pass filter with action = 'pass' (or vice versa with
action = 'stop'). Specifying both lwr and upr a bandpass/bandstop filter,
depending on 'action'}

\item{upr}{cutoff frequencies, Hz. Specifying just lwr gives a low-pass
filter, just upr high-pass filter with action = 'pass' (or vice versa with
action = 'stop'). Specifying both lwr and upr a bandpass/bandstop filter,
depending on 'action'}

\item{action}{"pass" = preserve the selected frequency range (bandpass),
"stop" = remove the selected frequency range (bandstop)}

\item{dB}{a positive number giving the strength of effect in dB (defaults to
Int - complete removal of selected frequencies)}

\item{na.rm}{if TRUE, NAs are interpolated, otherwise they are preserved in
the output}

\item{normalize}{if TRUE, resets the output to the original scale (otherwise
filtering often reduces the amplitude)}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\description{
Internal soundgen function
}
\keyword{internal}
