context("Test Credible Intervals")

x <- c(3.2256221093733, 5.6144429931384, 4.38507239444252, 2.71082755954577,
       1.8375366280866, 1.21092821707774, 10.6302371056121, 5.77731695073663,
       1.06373195797611, 5.14406697574219, 2.10968955793971, 5.00449355015642,
       1.40025690365501, 0.819312688549081, 3.73182760660764, 0.999997044398343,
       5.29453466203047, 0.909846434154109, 1.51581213982863, 3.88880077185331,
       3.87458822681169, 3.04705477524177, 5.47835694932151, 3.64132875604641,
       0.312914300963136, 1.3824061851282, 7.23475680735359, 9.02164957038833,
       0.851181436230586, 3.62508289382149, 7.92534072923446, 2.46474098438179,
       5.26485617787619, 2.87077678308005, 3.59913738486146, 3.74681892148822,
       2.03120750888876, 2.67534588954233, 2.13063136306292, 1.99163976596472,
       2.06635771896206, 2.13853657418636, 1.83139644612951, 1.09161046272732,
       2.47124249941365, 1.8401950923064, 0.458842306344179, 1.24099947121884,
       2.36762260223256, 4.85624819760986, 1.62045542219864, 2.07105920811999,
       6.4620990158136, 5.02475194720141, 6.9948666506439, 8.6626345401889,
       3.46626933880059, 2.87621734175716, 4.38270838006722, 10.1568894274496,
       0.101344155299878, 1.63838025888125, 2.08382860957998, 1.63971135538988,
       5.20727409886296, 0.952925811686489, 3.89518066708501, 1.5010453490809,
       3.03886501811205, 3.87693780735192, 3.62833457239798, 4.02466904530233,
       1.62896851245433, 4.5883693813122, 5.75770666679222, 4.80384727265605,
       4.91130348556208, 4.12722376516774, 3.01921768214573, 4.08754031510765,
       2.05858320987684, 3.03629906330083, 3.01918953907291, 0.964156710017327,
       4.42245417905842, 5.82629154267543, 5.24113838325852, 5.43629221310479,
       2.83057403113564, 13.9492709599127, 0.955681902495845, 2.95932596316881,
       2.63539959177618, 3.61309787649002, 2.2367414912074, 7.36961109652646,
       5.38615477512308, 7.03036879360517, 3.58285433576418, 8.58683943892606
)

test_that("Chen-Shao HPD", {
  expect_equal(ci_chenShao(x,0.05), c(lower=0.1013442,median=3.1363384,upper=8.6626345))
})

test_that("Percentile CI", {
  expect_equal(ci_percentiles(x,0.05), c(lower=0.3129143,median=3.1363384,upper=10.1568894))
})

test_that("SPIn CI", {
  expect_equal(ci_SPIn(x,0.05), structure(c(0.291033587535731, 3.13633844230753, 9.28191440839895
  ), .Names = c("lower", "median", "upper")))
})
