% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spScottKnott.R
\name{spScottKnott}
\alias{spScottKnott}
\alias{spScottKnott.SARanova}
\alias{spScottKnott.GEOanova}
\title{The Scott-Knott Clustering Algorithm}
\usage{
spScottKnott(x, sig.level = 0.05)

\method{spScottKnott}{SARanova}(x, sig.level = 0.05)

\method{spScottKnott}{GEOanova}(x, sig.level = 0.05)
}
\arguments{
\item{x}{a fitted model object of class SARcrd, SARrcbd or GEOanova.}

\item{sig.level}{a numeric value between zero and one giving the significance
level to use.}
}
\value{
a data frame containing the means and its group
}
\description{
This function implements the Scott-Knott Clustering
Algorithm for objects of class SARcrd, SARrcbd, and GEOanova.
}
\details{
For objects of class SARcrd or SARrcbd this function performs the standard Scott-Knott
Clustering Algorithm provided by the function \code{\link[ScottKnott]{SK}} on the
adjusted response.

For objects of class GEOanova, the method is modified to take into account the spatial
dependence among the observations. The method is described in Nogueira (2017).
}
\examples{
data("crd_simulated")

#Geodata object
geodados <- as.geodata(crd_simulated, coords.col = 1:2, data.col = 3,
                      covar.col = 4)
h_max <- summary(geodados)[[3]][[2]]
dist <- 0.6*h_max

# Computing the variogram
variograma <- spVariog(geodata = geodados,
                      trend = "cte", max.dist = dist, design = "crd",
                      scale = FALSE)

plot(variograma, ylab = "Semivariance", xlab = "Distance")

# Gaussian Model
ols <- spVariofit(variograma, cov.model = "gaussian", weights = "equal",
                 max.dist = dist)


# Compute the model and get the analysis of variance table
mod <- aovGeo(ols, cutoff = 0.6)

# Scott-Knott clustering algorithm
spScottKnott(mod)

}
\references{
Nogueira, C. H. Testes para comparações múltiplas de
médias em experimentos com tendência e dependência espacial.
142 f. Tese (Doutorado em Estatística e Experimentação
Agropecuária) | Universidade Federal de Lavras, Lavras, 2017
}
