% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{simplex}
\alias{simplex}
\alias{simplex,sf-method}
\alias{simplex,SpatRaster-method}
\title{simplex forecasting}
\usage{
\S4method{simplex}{sf}(
  data,
  target,
  lib,
  pred = lib,
  E = 1:10,
  k = 4,
  nb = NULL,
  threads = detectThreads(),
  include.self = FALSE
)

\S4method{simplex}{SpatRaster}(
  data,
  target,
  lib,
  pred = lib,
  E = 1:10,
  k = 4,
  threads = detectThreads(),
  include.self = FALSE
)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{lib}{The row numbers(\code{vector}) of lattice data or the row-column numbers(\code{matrix}) of grid data for creating the library from observations.}

\item{pred}{(optional) The row numbers(\code{vector}) of lattice data or the row-column numbers(\code{matrix}) of grid data used for predictions.}

\item{E}{(optional) The dimensions of the embedding.}

\item{k}{(optional) Number of nearest neighbors to use for prediction.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{include.self}{(optional) Whether to include the current state when constructing the embedding vector.}
}
\value{
A matrix
}
\description{
simplex forecasting
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData")[1],
                       quiet=TRUE)
\donttest{
simplex(columbus,target = "CRIME",lib = 1:29,pred = 30:49)
}
}
