% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedded.R
\name{embedded}
\alias{embedded}
\alias{embedded,sf-method}
\alias{embedded,SpatRaster-method}
\title{embedding spatial cross sectional data}
\usage{
\S4method{embedded}{sf}(data, target, E = 3, tau = 1, nb = NULL, trend.rm = FALSE)

\S4method{embedded}{SpatRaster}(data, target, E = 3, tau = 1, trend.rm = FALSE)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{nb}{(optional) The neighbours list.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}
}
\value{
A matrix
}
\description{
embedding spatial cross sectional data
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData"))
embedded(columbus,target = "CRIME", E = 3)

}
