% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions_sf.R
\name{lixelize_lines}
\alias{lixelize_lines}
\title{Cut lines into lixels}
\usage{
lixelize_lines(lines, lx_length, mindist = NULL)
}
\arguments{
\item{lines}{The sf object with linestring geometry type to modify}

\item{lx_length}{The length of a lixel}

\item{mindist}{The minimum length of a lixel. After cut, if the length of the
final lixel is shorter than the minimum distance, then it is added to the
previous lixel. if NULL, then mindist = maxdist/10. Note that the segments
that are already shorter than the minimum distance are not modified.}
}
\value{
An sf object with linestring geometry type
}
\description{
Cut the lines of a feature collection of linestrings into lixels with a specified minimal
  distance may fail if the line geometries are self intersecting.
}
\examples{
\donttest{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- sf::st_read(networkgpkg,layer="mtl_network")
lixels <- lixelize_lines(mtl_network,150,50)
}
}
