% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{hsvd_vec}
\alias{hsvd_vec}
\title{HSVD of a complex vector.}
\usage{
hsvd_vec(y, fs, comps = 40, irlba = TRUE, max_damp = 0)
}
\arguments{
\item{y}{time domain signal to be filtered as a vector.}

\item{fs}{sampling frequency of y.}

\item{comps}{number of Lorentzian components to use for modelling.}

\item{irlba}{option to use irlba SVD (logical).}

\item{max_damp}{maximum allowable damping factor. Default value of 0 ensures
resultant model is damped.}
}
\value{
basis matrix and signal table.
}
\description{
HSVD method as described in:
Barkhuijsen H, de Beer R, van Ormondt D. Improved algorithm for noniterative
and timedomain model fitting to exponentially damped magnetic resonance
signals. J Magn Reson 1987;73:553-557.
}
