% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rats.R
\name{rats}
\alias{rats}
\title{Robust Alignment to a Target Spectrum (RATS).}
\usage{
rats(
  mrs_data,
  ref = NULL,
  xlim = c(4, 0.5),
  max_shift = 20,
  p_deg = 2,
  sp_N = 2,
  sp_deg = 3,
  max_t = 0.2,
  basis_type = "poly",
  rescale_output = TRUE,
  phase_corr = TRUE,
  ret_corr_only = TRUE,
  zero_freq_shift_t0 = FALSE,
  remove_freq_outliers = FALSE,
  freq_outlier_thresh = 3,
  remove_phase_outliers = FALSE,
  phase_outlier_thresh = 3,
  remove_amp_outliers = FALSE,
  amp_outlier_thresh = 3
)
}
\arguments{
\item{mrs_data}{MRS data to be corrected.}

\item{ref}{optional MRS data to use as a reference, the mean of all dynamics
is used if this argument is not supplied.}

\item{xlim}{optional frequency range to perform optimisation, set to NULL
to use the full range.}

\item{max_shift}{maximum allowable frequency shift in Hz.}

\item{p_deg}{polynomial degree used for baseline modelling. Negative values
disable baseline modelling.}

\item{sp_N}{number of spline functions, note the true number will be sp_N +
sp_deg.}

\item{sp_deg}{degree of spline functions.}

\item{max_t}{truncate the FID when longer than max_t to reduce time taken,
set to NULL to use the entire FID.}

\item{basis_type}{may be one of "poly" or "spline".}

\item{rescale_output}{rescale the bl_matched_spec and bl output to improve
consistency between dynamic scans.}

\item{phase_corr}{apply phase correction (in addition to frequency). TRUE by
default.}

\item{ret_corr_only}{return the corrected mrs_data object only.}

\item{zero_freq_shift_t0}{perform a linear fit to the frequency shifts and
set the (linearly modeled) shift to be 0 Hz for the first dynamic scan.}

\item{remove_freq_outliers}{remove dynamics based on their frequency shift.}

\item{freq_outlier_thresh}{threshold to remove frequency outliers.}

\item{remove_phase_outliers}{remove dynamics based on their phase shift.}

\item{phase_outlier_thresh}{threshold to remove phase outliers.}

\item{remove_amp_outliers}{remove dynamics based on their amplitude change.}

\item{amp_outlier_thresh}{threshold to remove amplitude outliers.}
}
\value{
a list containing the corrected data; phase and shift values in units
of degrees and Hz respectively.
}
\description{
Robust Alignment to a Target Spectrum (RATS).
}
