% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrs.R
\name{gen_trap_rf}
\alias{gen_trap_rf}
\title{Generate a trapezoidal response function.}
\usage{
gen_trap_rf(
  onset,
  duration,
  trial_type,
  mrs_data,
  rise_t = 0,
  fall_t = 0,
  smo_sigma = NULL,
  match_tr = TRUE,
  dt = 0.01,
  normalise = TRUE
)
}
\arguments{
\item{onset}{stimulus onset in seconds.}

\item{duration}{stimulus duration in seconds.}

\item{trial_type}{string label for the stimulus.}

\item{mrs_data}{mrs_data object for timing information.}

\item{rise_t}{rise time of the trapezoid in seconds.}

\item{fall_t}{fall time of the trapezoid in seconds}

\item{smo_sigma}{standard deviation of Gaussian smoothing kernel in seconds.
Set to NULL to disable (default behavior).}

\item{match_tr}{match the output to the input mrs_data.}

\item{dt}{timing resolution for internal calculations.}

\item{normalise}{normalise the response function to have a maximum value of
one.}
}
\value{
trapezoidal response function.
}
\description{
Generate a trapezoidal response function.
}
