% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs_batch_fit.R
\name{svs_1h_brain_batch_analysis}
\alias{svs_1h_brain_batch_analysis}
\title{Batch interface to the standard SVS 1H brain analysis pipeline.}
\usage{
svs_1h_brain_batch_analysis(
  metab_list,
  w_ref_list = NULL,
  mri_seg_list = NULL,
  mri_list = NULL,
  output_dir_list = NULL,
  extra = NULL,
  ...
)
}
\arguments{
\item{metab_list}{list of file paths or mrs_data objects containing MRS
metabolite data.}

\item{w_ref_list}{list of file paths or mrs_data objects containing MRS
water reference data.}

\item{mri_seg_list}{list of file paths or nifti objects containing segmented
MRI data.}

\item{mri_list}{list of file paths or nifti objects containing anatomical
MRI data.}

\item{output_dir_list}{list of directory paths to output fitting results.}

\item{extra}{a data frame with the same number of rows as metab_list,
containing additional information to be attached to the fit results table.}

\item{...}{additional options to be passed to the svs_1h_brain_analysis
function.}
}
\value{
a list of fit_result objects.
}
\description{
Batch interface to the standard SVS 1H brain analysis pipeline.
}
