% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{fit_asy_pvoigt}
\alias{fit_asy_pvoigt}
\title{Fit a single asymmetric pseudo-Voigt resonance in the frequency domain.}
\usage{
fit_asy_pvoigt(
  mrs_data,
  freq_ppm = 4.65,
  xlim = c(5.2, 4.1),
  lg_limits = c(0, 1)
)
}
\arguments{
\item{mrs_data}{data containing the resonance to be fit.}

\item{freq_ppm}{frequency estimate (in ppm) for the resonance to be fitted.}

\item{xlim}{spectral range (in ppm) where the fit will be evaluated.}

\item{lg_limits}{lg lineshape parameter limits.}
}
\value{
list of fitting results and parameters.
}
\description{
Fit a single asymmetric pseudo-Voigt resonance in the frequency domain.
}
