/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.Random$;
import sparklyr.Backend;
import sparklyr.JVMObjectTracker$;
import sparklyr.Logger;
import sparklyr.Rscript;
import sparklyr.WorkerContext;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u000b\tIqk\u001c:lKJ\u0014F\t\u0012\u0006\u0002\u0007\u0005A1\u000f]1sW2L(o\u0001\u0001\u0016\u0005\u0019)2C\u0001\u0001\b!\rA\u0011cE\u0007\u0002\u0013)\u0011!bC\u0001\u0004e\u0012$'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\n\u0005II!a\u0001*E\tB\u0011A#\u0006\u0007\u0001\t\u00151\u0002A1\u0001\u0018\u0005\u0005!\u0016C\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!G\u0010\n\u0005\u0001R\"aA!os\"A!\u0005\u0001B\u0001B\u0003%q!\u0001\u0004qCJ,g\u000e\u001e\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u000591\r\\8tkJ,\u0007cA\r'Q%\u0011qE\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00033%J!A\u000b\u000e\u0003\t\tKH/\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u000591m\u001c7v[:\u001c\bcA\r']A\u0011qF\r\b\u00033AJ!!\r\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003ciA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0007G>tg-[4\t\u0011a\u0002!\u0011!Q\u0001\ne\nA\u0001]8siB\u0011\u0011DO\u0005\u0003wi\u00111!\u00138u\u0011!i\u0004A!A!\u0002\u0013i\u0013aB4s_V\u0004()\u001f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005K\u0005a1\r\\8tkJ,'\u000bT1oO\"A\u0011\t\u0001B\u0001B\u0003%a&\u0001\u0006ck:$G.\u001a)bi\"D\u0001b\u0011\u0001\u0003\u0004\u0003\u0006Y\u0001R\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA#I'5\taI\u0003\u0002H5\u00059!/\u001a4mK\u000e$\u0018BA%G\u0005!\u0019E.Y:t)\u0006<\u0007\"B&\u0001\t\u0003a\u0015A\u0002\u001fj]&$h\bF\u0005N#J\u001bF+\u0016,X1R\u0011a\n\u0015\t\u0004\u001f\u0002\u0019R\"\u0001\u0002\t\u000b\rS\u00059\u0001#\t\u000b\tR\u0005\u0019A\u0004\t\u000b\u0011R\u0005\u0019A\u0013\t\u000b1R\u0005\u0019A\u0017\t\u000bYR\u0005\u0019\u0001\u0018\t\u000baR\u0005\u0019A\u001d\t\u000buR\u0005\u0019A\u0017\t\u000b}R\u0005\u0019A\u0013\t\u000b\u0005S\u0005\u0019\u0001\u0018\t\ri\u0003\u0001\u0015)\u0003\\\u0003%)\u0007pY3qi&|g\u000eE\u0002\u001a9zK!!\u0018\u000e\u0003\r=\u0003H/[8o!\tyvM\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111\rB\u0001\u0007yI|w\u000e\u001e \n\u0003mI!A\u001a\u000e\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\n\u000bb\u001cW\r\u001d;j_:T!A\u001a\u000e\t\u000b-\u0004A\u0011\t7\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\u0005i\u0007cA\r']B\u0011q\u000e]\u0007\u0002\u0017%\u0011\u0011o\u0003\u0002\n!\u0006\u0014H/\u001b;j_:DQa\u001d\u0001\u0005BQ\fqaY8naV$X\rF\u0002vqj\u00042a\u0018<\u0014\u0013\t9\u0018N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u0015I(\u000f1\u0001o\u0003\u0015\u0019\b\u000f\\5u\u0011\u0015Y(\u000f1\u0001}\u0003\u0011!\u0018m]6\u0011\u0005=l\u0018B\u0001@\f\u0005-!\u0016m]6D_:$X\r\u001f;")
public class WorkerRDD<T>
extends RDD<T> {
    private final RDD<T> parent;
    private final byte[] closure;
    private final String[] columns;
    public final String sparklyr$WorkerRDD$$config;
    public final int sparklyr$WorkerRDD$$port;
    private final String[] groupBy;
    private final byte[] closureRLang;
    private final String bundlePath;
    private final ClassTag<T> evidence$1;
    public Option<Exception> sparklyr$WorkerRDD$$exception;

    public Partition[] getPartitions() {
        return this.parent.partitions();
    }

    public Iterator<T> compute(Partition split, TaskContext task) {
        int sessionId = Random$.MODULE$.nextInt(10000);
        Logger logger = new Logger("Worker", sessionId);
        Object lock = new Object();
        WorkerContext<T> workerContext = new WorkerContext<T>(this.parent, split, task, lock, this.closure, this.columns, this.groupBy, this.closureRLang, this.bundlePath, this.evidence$1);
        String contextId = JVMObjectTracker$.MODULE$.put(workerContext);
        logger.log(new StringBuilder().append((Object)"is tracking worker context under ").append((Object)contextId).toString());
        new Thread(this, sessionId, logger, lock, contextId){
            private final /* synthetic */ WorkerRDD $outer;
            private final int sessionId$1;
            private final Logger logger$1;
            private final Object lock$1;
            private final String contextId$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    this.logger$1.log("starting backend");
                    Backend backend = new Backend();
                    backend.setType(true, false, true);
                    backend.setHostContext(this.contextId$1);
                    backend.init(this.$outer.sparklyr$WorkerRDD$$port, this.sessionId$1);
                    return;
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed to start backend: ", exception);
                    this.$outer.sparklyr$WorkerRDD$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                        return;
                    }
                }
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sessionId$1 = sessionId$1;
                this.logger$1 = var3_3;
                this.lock$1 = var4_4;
                this.contextId$1 = var5_5;
                super("starting backend thread");
            }
        }.start();
        new Thread(this, sessionId, logger, lock){
            private final /* synthetic */ WorkerRDD $outer;
            private final int sessionId$1;
            private final Logger logger$1;
            private final Object lock$1;

            public void run() {
                try {
                    this.logger$1.log("is starting rscript");
                    Rscript rscript = new Rscript(this.logger$1);
                    rscript.init(this.sessionId$1, this.$outer.sparklyr$WorkerRDD$$config);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed to run rscript: ", exception);
                    this.$outer.sparklyr$WorkerRDD$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sessionId$1 = sessionId$1;
                this.logger$1 = var3_3;
                this.lock$1 = var4_4;
                super("starting rscript thread");
            }
        }.start();
        logger.log("is waiting using lock for RScript to complete");
        Object object = lock;
        synchronized (object) {
            lock.wait();
            // ** MonitorExit[lock] (shouldn't be in output)
            logger.log("completed wait using lock for RScript");
            if (this.sparklyr$WorkerRDD$$exception.isDefined()) {
                throw (Throwable)this.sparklyr$WorkerRDD$$exception.get();
            }
            return Predef$.MODULE$.genericArrayOps(workerContext.getResultArray()).iterator();
        }
    }

    public WorkerRDD(RDD<T> parent, byte[] closure, String[] columns, String config, int port, String[] groupBy2, byte[] closureRLang, String bundlePath, ClassTag<T> evidence$1) {
        this.parent = parent;
        this.closure = closure;
        this.columns = columns;
        this.sparklyr$WorkerRDD$$config = config;
        this.sparklyr$WorkerRDD$$port = port;
        this.groupBy = groupBy2;
        this.closureRLang = closureRLang;
        this.bundlePath = bundlePath;
        this.evidence$1 = evidence$1;
        super(parent, evidence$1);
        this.sparklyr$WorkerRDD$$exception = None$.MODULE$;
    }
}

