% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers_ml_linear_models.R
\name{ml_glm_tidiers}
\alias{ml_glm_tidiers}
\alias{tidy.ml_model_generalized_linear_regression}
\alias{tidy.ml_model_linear_regression}
\alias{augment.ml_model_generalized_linear_regression}
\alias{augment.ml_model_linear_regression}
\alias{glance.ml_model_generalized_linear_regression}
\alias{glance.ml_model_linear_regression}
\title{Tidying methods for Spark ML linear models}
\usage{
\method{tidy}{ml_model_generalized_linear_regression}(x,
  exponentiate = FALSE, ...)

\method{tidy}{ml_model_linear_regression}(x, ...)

\method{augment}{ml_model_generalized_linear_regression}(x,
  newdata = NULL, type.residuals = c("working", "deviance", "pearson",
  "response"), ...)

\method{augment}{ml_model_linear_regression}(x, newdata = NULL,
  type.residuals = c("working", "deviance", "pearson", "response"), ...)

\method{glance}{ml_model_generalized_linear_regression}(x, ...)

\method{glance}{ml_model_linear_regression}(x, ...)
}
\arguments{
\item{x}{a Spark ML model.}

\item{exponentiate}{For GLM, whether to exponentiate the coefficient estimates (typical for logistic regression.)}

\item{...}{extra arguments (not used.)}

\item{newdata}{a tbl_spark of new data to use for prediction.}

\item{type.residuals}{type of residuals, defaults to \code{"working"}. Must be set to
\code{"working"} when \code{newdata} is supplied.}
}
\description{
These methods summarize the results of Spark ML models into tidy forms.
}
\details{
The residuals attached by \code{augment} are of type "working" by default,
  which is different from the default of "deviance" for \code{residuals()} or \code{sdf_residuals()}.
}
