% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_insert_table}
\alias{spark_insert_table}
\title{Inserts a Spark DataFrame into a Spark table}
\usage{
spark_insert_table(
  x,
  name,
  mode = NULL,
  overwrite = FALSE,
  options = list(),
  ...
)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{name}{The name to assign to the newly generated table.}

\item{mode}{A \code{character} element. Specifies the behavior when data or
  table already exists. Supported values include: 'error', 'append', 'overwrite' and
  ignore. Notice that 'overwrite' will also change the column structure.

  For more details see also \url{https://spark.apache.org/docs/latest/sql-programming-guide.html#save-modes}
  for your version of Spark.}

\item{overwrite}{Boolean; overwrite the table with the given name if it
already exists?}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Inserts a Spark DataFrame into a Spark table
}
\seealso{
Other Spark serialization routines: 
\code{\link{collect_from_rds}()},
\code{\link{spark_load_table}()},
\code{\link{spark_read_avro}()},
\code{\link{spark_read_binary}()},
\code{\link{spark_read_csv}()},
\code{\link{spark_read_delta}()},
\code{\link{spark_read_image}()},
\code{\link{spark_read_jdbc}()},
\code{\link{spark_read_json}()},
\code{\link{spark_read_libsvm}()},
\code{\link{spark_read_orc}()},
\code{\link{spark_read_parquet}()},
\code{\link{spark_read_source}()},
\code{\link{spark_read_table}()},
\code{\link{spark_read_text}()},
\code{\link{spark_read}()},
\code{\link{spark_save_table}()},
\code{\link{spark_write_avro}()},
\code{\link{spark_write_csv}()},
\code{\link{spark_write_delta}()},
\code{\link{spark_write_jdbc}()},
\code{\link{spark_write_json}()},
\code{\link{spark_write_orc}()},
\code{\link{spark_write_parquet}()},
\code{\link{spark_write_source}()},
\code{\link{spark_write_table}()},
\code{\link{spark_write_text}()}
}
\concept{Spark serialization routines}
