efast_process_netlogo_result <-
function(FILEPATH,EFASTSAMPLE_RESULTFILENAME,PARAMETERS,NUMCURVES,NUMSAMPLES,MEASURES,RESULTFILEFORMAT,RESULTFILENAME,TIMESTEP)
{
	# TO KEEP THIS IN LINE WITH TRADITIONAL SPARTAN, AND AS NETLOGO OFFERS THE CHANCE TO RUN REPEATED RUNS OF THE SAME EXPERIMENT
	# WE ARE GOING TO CREATE A MEDIAN SET OF RESULTS FOR EACH LHC SAMPLE. THEN THE OLD SPARTAN CODE CAN BE USED FROM THAT POINT
	
	# BUT FIRST, WE MAY NEED TO CHANGE THE PARAMETER AND MEASURE STRINGS. WHEN R IMPORTS THE SPREADSHEET, ANY HYPHENS OR SPACES ARE CHANGED
	# TO DOTS, AND THIS NEEDS DETECTING
	PARAMETERS<-table_header_check(PARAMETERS)
	MEASURES<-table_header_check(MEASURES)


	for(CURVENUM in 1:NUMCURVES)
	{
		for(PARAMNUM in 1:length(PARAMETERS))
		{
			for(SAMPLE in 1:NUMSAMPLES)
			{
				if(file.exists(paste(FILEPATH,"/",CURVENUM,"/",PARAMNUM,"/",SAMPLE,"/",EFASTSAMPLE_RESULTFILENAME,SAMPLE,".csv",sep="")))
				{
					print(paste("Processing EFAST Results for Curve: ",CURVENUM," Parameter: ", PARAMNUM," Value Sample: ",SAMPLE,sep=""))

					# READ IN THE RESULT FILE
					# SKIP THE FIRST 6 LINES AS NONE OF THIS INFORMATION IS REQUIRED
					NL_RESULT<-read.csv(paste(FILEPATH,"/",CURVENUM,"/",PARAMNUM,"/",SAMPLE,"/",EFASTSAMPLE_RESULTFILENAME,SAMPLE,".csv",sep=""),sep=",",skip=6)

					# ORDER IT BY RUN FOR EFFICIENCY LATER
					NL_RESULT_ORDERED<-NL_RESULT[order(NL_RESULT[,1]),]
	
					# REMOVE ALL THE OTHER TIMESTEPS AS NOT REQUIRED
					# THE TIMESTEP IS IN THE COLUMN HEADED X.step.
					# SET THIS TO NULL TO PLEASE CRAN SUBMISSION NOTE, THEN SUBSET
					X.step.<-NULL
					TIMESTEP_RESULTS<-subset(NL_RESULT_ORDERED,X.step.==TIMESTEP)

					# NOW TO CREATE THE RESULTS FOR THIS SAMPLE SET
					# NETLOGO DOES GIVE THE OPTION OF RUNNING REPLICATES OF THE SAME EXPERIMENT
					# SO THERE MAY BE A FEW ROWS HERE. IF SO, LETS TAKE THE MEDIAN OF THE MEASURES, AS WE WOULD WITH TRADITIONAL SPARTAN
					MEDIANSFORALLMEASURES<-NULL

					for(RESPONSE in 1:length(MEASURES))
					{
						MEDIANSFORALLMEASURES<-cbind(MEDIANSFORALLMEASURES,median(TIMESTEP_RESULTS[MEASURES[RESPONSE]][,1]))
					}

					# NAME THE COLUMNS TO MATCH THE MEASURES
					colnames(MEDIANSFORALLMEASURES)<-MEASURES

					PARAM_RESULTFILEPATH = paste(FILEPATH,"/",CURVENUM,"/",PARAMNUM,"/",SAMPLE,"/",RESULTFILENAME,sep="")

					if(RESULTFILEFORMAT=="csv")
					{
						write.csv(MEDIANSFORALLMEASURES,paste(PARAM_RESULTFILEPATH,".csv",sep=""),quote = FALSE,row.names=FALSE)
					}
					else if(RESULTFILEFORMAT=="xml")
					{
						RESULTSDF<-data.frame(MEDIANSFORALLMEASURES)
			
						#xml <- xmlTree()
						xml<-xmlOutputDOM()
						xml$addTag("simResults", close=FALSE)
						for (i in 1:nrow(RESULTSDF)) 
						{
							xml$addTag("runMedians", close=FALSE)
							for (j in names(RESULTSDF)) 
							{
								xml$addTag(j, RESULTSDF[i, j])
							}
							xml$closeTag()
						}
						xml$closeTag()	
			
						saveXML(xml,file=paste(PARAM_RESULTFILEPATH,".xml",sep=""),indent=FALSE)
					}
				
				}
				else
				{
					print(paste("ERROR: Results for Curve ",CURVENUM," Parameter ",PARAMNUM," Sample ",SAMPLE," not found",sep=""))

				}
			}
		}

		print(paste("Analysis of Netlogo Results for Curve ",CURVENUM," Complete",sep=""))
	}
}
	

