perform_aTest_for_all_sim_measures<-function(PARAMETER_SET, BASELINE_RESULT,PARAMETER_SET_RESULT,MEASURES)
{
	# TAKES A SET OF PARAMETERS ON WHICH A SIMULATION WAS RUN (PARAMETER_SET), THE RESULTS FOR THIS SET (PARAMETER_SET_RESULT),
	# THE SIMULATION BASELINE BEHAVIOUR (BASELINE_RESULT) AND PERFORMS THE A-TEST TO GET A COMPARISON FOR ALL SIMULATION MEASURES
	# (MEASURES)

	ATESTRESULTROW<-t(PARAMETER_SET)

	for(MEASURE in 1:length(MEASURES))
	{
		ATESTMEASURERESULT<-atest(as.numeric(as.matrix(BASELINE_RESULT[MEASURES[MEASURE]])),
					as.numeric(as.matrix(PARAMETER_SET_RESULT[MEASURES[MEASURE]][,1])))
			
		ATESTNORM<-normaliseATest(ATESTMEASURERESULT)

		# ADD TO THE SET OF RESULTS
		ATESTRESULTROW<-cbind(ATESTRESULTROW,ATESTMEASURERESULT,ATESTNORM)
	}

	return(ATESTRESULTROW)

}
