% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_utilities.R
\name{create_ensemble}
\alias{create_ensemble}
\title{Internal function to create the ensemble}
\usage{
create_ensemble(ensemble_emulations, all_emulator_predictions,
  emulator_test_data, measures, emulator_types, pre_normed_mins,
  pre_normed_maxes, algorithm_settings = NULL, normalise = FALSE,
  timepoint = NULL)
}
\arguments{
\item{ensemble_emulations}{All emulations to build into the ensemble}

\item{all_emulator_predictions}{Test set predictions from all emulators, on
which the ensemble will be trained / emulators weighted}

\item{emulator_test_data}{Data on which the ensemble performance will be
assessed}

\item{measures}{Simulation responses the model should predict}

\item{emulator_types}{Machine learning techniques being employed}

\item{pre_normed_mins}{The minimum values of each parameter prior to data
normalisation. Used to rescale the results}

\item{pre_normed_maxes}{The maximum values of each parameter prior to data
normalisation. Used to rescale the results}

\item{algorithm_settings}{Object output from the function
emulation_algorithm_settings, containing the settings of the machine
learning algorithms to use in emulation creation. Used here to obtain
settings relevant to ensemble creation - namely number of generations and
whether the ensemble should be saved to file, as well as whether plots
should be produced showing ensemble performance.}

\item{normalise}{Whether the predictions generated when testing the
ensemble should be normalised for presenting test results}

\item{timepoint}{Simulation timepoint for which an ensemble is being created}
}
\value{
Generated ensemble object
}
\description{
Internal function to create the ensemble
}
