% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_analysis.R
\name{efast_generate_medians_for_all_parameter_subsets_overTime}
\alias{efast_generate_medians_for_all_parameter_subsets_overTime}
\title{Pre-process analysis settings if multiple timepoints are being considered}
\usage{
efast_generate_medians_for_all_parameter_subsets_overTime(FILEPATH, NUMCURVES,
  PARAMETERS, NUMSAMPLES, NUMRUNSPERSAMPLE, MEASURES, RESULTFILENAME,
  ALTERNATIVEFILENAME, OUTPUTCOLSTART, OUTPUTCOLEND, TIMEPOINTS, TIMEPOINTSCALE)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs can be found, in folders
or in CSV file format}

\item{NUMCURVES}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{NUMSAMPLES}{The number of parameter subsets that were generated in
the eFAST design}

\item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter
subset. This figure can be generated through Aleatory Analysis}

\item{MEASURES}{Array containing the names of the output measures which
are used to analyse the simulation}

\item{RESULTFILENAME}{{Name of the simulation results file. In the current
version, XML and CSV files can be processed. If performing this analysis
over multiple timepoints, it is assumed that the timepoint follows the
file name, e.g. trackedCells_Close_12.csv.}}

\item{ALTERNATIVEFILENAME}{In some cases, it may be relevant to read from
a further results file if the initial file contains no results. This
filename is set here. In the current version, XML and CSV files can be
processed.}

\item{OUTPUTCOLSTART}{Column number in the simulation results file where
output begins - saves (a) reading in unnecessary data, and (b) errors
where the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTCOLEND}{Column number in the simulation results file where the
last output measure is. Only required if running the first method.}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this
should be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Sets the scale of the timepoints being analysed,
e.g. "Hours"}
}
\description{
Pre-process analysis settings if multiple timepoints are being considered
}
