#' Deprecated: Use \code{efast_netlogo_get_overall_medians}
#'
#' @inheritParams efast_get_overall_medians
#'
#' @export
efast_netlogo_get_overall_medians <-
  function(FILEPATH, NUMCURVES, PARAMETERS, NUMSAMPLES, MEASURES,
           TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL) {

    #message("Now Deprecated. Use efast_get_overall_medians instead")
    .Deprecated("efast_get_overall_medians")

}

#' Deprecated: Use \code{efast_run_Analysis}
#'
#' @inheritParams efast_run_Analysis
#'
#' @export
efast_netlogo_run_Analysis <-
  function(FILEPATH, MEASURES, PARAMETERS, NUMCURVES, NUMSAMPLES,
           OUTPUTMEASURES_TO_TTEST, TTEST_CONF_INT, GRAPH_FLAG,
           EFASTRESULTFILENAME, TIMEPOINTS, TIMEPOINTSCALE) {

    .Deprecated("efast_run_Analysis")
}

#' Analyses Netlogo simulation data for parameter sets generated for eFAST
#'
#' Takes each parameter value set generated by eFAST in turn, and analyses the
#' Netlogo simulation results.  For each parameter set, there will be n
#' simulation results. This method goes through these results, producing
#' a file containing the median of each output measure for each of the n runs.
#' Thus, if a Netlogo simulation was replicated 10 times, the median file will
#' contain 10 medians for each simulation output measure. The user should then
#' run  \code{efast_get_overall_medians} and
#' \code{efast_run_Analysis} to analyse the results
#'
#' @param FILEPATH Directory where the simulation runs can be found
#' @param EFASTSAMPLE_RESULTFILENAME Name of the result file generated by
#' Netlogo, for an eFAST parameter sample.
#' @param PARAMETERS Array containing the names of the parameters of which
#' parameter samples will be generated
#' @param NUMCURVES The number of 'resamples' to perform
#' (see eFAST documentation) - recommend using at least 3.
#' @param NUMSAMPLES The number of parameter subsets that were generated
#' from each curve in the eFAST design
#' @param MEASURES Array containing the names of the Netlogo output measures
#' which are used to analyse the simulation.
#' @param RESULTFILENAME Name of the result file that will be produced which
#' summarises all results
#' @param TIMESTEP Timestep of the Netlogo simulation being analysed.
#'
#' @export
efast_process_netlogo_result <-
  function(FILEPATH, EFASTSAMPLE_RESULTFILENAME, PARAMETERS, NUMCURVES,
           NUMSAMPLES, MEASURES, RESULTFILENAME, TIMESTEP) {

  # TO KEEP THIS IN LINE WITH TRADITIONAL SPARTAN, AND AS NETLOGO OFFERS
  #THE CHANCE TO RUN REPEATED RUNS OF THE SAME EXPERIMENT
  # WE ARE GOING TO CREATE A MEDIAN SET OF RESULTS FOR EACH SAMPLE.
  # THEN THE OLD SPARTAN CODE CAN BE USED FROM THAT POINT

  for (CURVENUM in 1:NUMCURVES) {
    for (PARAMNUM in 1:length(PARAMETERS)) {

      message(paste("Processing Curve: ", CURVENUM, " Parameter: ",
                  PARAMETERS[PARAMNUM], sep = ""))
      # Open the parameter file
      params <- read_from_csv(file.path(
        FILEPATH, paste("Curve", CURVENUM, "_", PARAMETERS[PARAMNUM], ".csv",
                        sep = "")))

      CURVE_PARAM_RESULT <- NULL

      for (SAMPLE in 1:NUMSAMPLES) {
        if (file.exists(paste(FILEPATH, "/", CURVENUM, "/", PARAMNUM,
                             "/", SAMPLE, "/", EFASTSAMPLE_RESULTFILENAME,
                             SAMPLE, ".csv", sep = ""))) {

         message(paste("Processing EFAST Results for Curve: ", CURVENUM,
                      " Parameter: ", PARAMNUM, " Value Sample: ", SAMPLE,
                      sep = ""))

          # READ IN THE RESULT FILE
          # SKIP THE FIRST 6 LINES AS NONE OF THIS INFORMATION IS REQUIRED
          NL_RESULT <- read.csv(paste(FILEPATH, "/", CURVENUM, "/", PARAMNUM,
                                      "/", SAMPLE, "/",
                                      EFASTSAMPLE_RESULTFILENAME, SAMPLE,
                                      ".csv", sep = ""), sep = ",",
                                skip = 6, check.names = FALSE)

          # ORDER IT BY RUN FOR EFFICIENCY LATER
          NL_RESULT_ORDERED <- NL_RESULT[order(NL_RESULT[, 1]), ]

          TIMESTEP_RESULTS <- subset(NL_RESULT_ORDERED,
                                     NL_RESULT_ORDERED["[step]"] == TIMESTEP)

          # NOW TO CREATE THE RESULTS FOR THIS SAMPLE SET
          # NETLOGO DOES GIVE THE OPTION OF RUNNING REPLICATES OF SAME EXPT
          # THERE MAY BE A FEW ROWS HERE. SO SUMMARISE THESE

          # FIRST LETS SET UP THE NUMBER OF PARAMETER ROWS
          param_set <- params[SAMPLE, ]

          # Make duplicates of the parameters to match number of replicate runs
          PARAMS <- NULL
          for (paramval in 1:ncol(param_set)) {
            PARAMS <- cbind(PARAMS, param_set[[paramval]])
          }


          DUP_PARAMS <- NULL
          for (r in 1:nrow(TIMESTEP_RESULTS) - 1) {
            DUP_PARAMS <- rbind(DUP_PARAMS, PARAMS)
          }

          # NOW WE CAN ADD THE RESULTS FOR EACH NETLOGO RUN
          for (RESPONSE in 1:length(MEASURES)) {
            DUP_PARAMS <- cbind(DUP_PARAMS,
                                TIMESTEP_RESULTS[MEASURES[RESPONSE]][, 1])
          }

          CURVE_PARAM_RESULT <- rbind(CURVE_PARAM_RESULT, DUP_PARAMS)
        }
      }

      colnames(CURVE_PARAM_RESULT) <- c(colnames(params), MEASURES)

      # Write this file out to the FILEPATH
      write_data_to_csv(CURVE_PARAM_RESULT, file.path(
        FILEPATH, paste("Curve",CURVENUM,"_Parameter",PARAMNUM,"_Results.csv",sep="")))
    }

    message(paste("Analysis of Netlogo Results for Curve ", CURVENUM,
                " Complete", sep = ""))
  }
}
