% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_plotting.R
\name{lhc_graphMeasuresForParameterChange}
\alias{lhc_graphMeasuresForParameterChange}
\title{Generates parameter/measure plot for each pairing in the analysis}
\usage{
lhc_graphMeasuresForParameterChange(FILEPATH, PARAMETERS, MEASURES,
  MEASURE_SCALE, CORCOEFFSOUTPUTFILE, LHCSUMMARYFILENAME,
  OUTPUT_TYPE = c("PDF"), TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL,
  GRAPHTIME = NULL, check_done = FALSE,
  corcoeffs_output_object = NULL, lhc_summary_object = NULL)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs of single CSV file can
be found}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{MEASURES}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{MEASURE_SCALE}{Scale in which each of the output responses is
measured. Used to label plots}

\item{CORCOEFFSOUTPUTFILE}{File produced by spartan containing the Partial
Rank Correlation Coefficients for each parameter/measure pairing}

\item{LHCSUMMARYFILENAME}{Name of the LHC Summary file to be generated.
Contains each parameter set alongside the result gained when the simulation
was run under that criteria.}

\item{OUTPUT_TYPE}{Type of graph to plot. Can be PDF, PNG, TIFF, BMP, etc,
all formats supported by ggplot2}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this should
be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing
multiple simulation timepoints. Sets the scale of the timepoints being
analysed, e.g. "Hours"}

\item{GRAPHTIME}{The timepoint being processed, if any. NULL if not.}

\item{check_done}{For multiple timepoints, whether input has been checked}

\item{corcoeffs_output_object}{Correlation coefficients can be input as an
R object as well as CSV file. In this case, CORCOEFFSOUTPUTFILE will be NULL}

\item{lhc_summary_object}{If not specified in a CSV file, results can be specified in an
R object. In this case LHCSUMMARYFILENAME will be NULL}
}
\description{
Produces a graph for each parameter, and each output measure, showing
the simulation output achieved when that parameter was assigned that value.
Eases identification of any non-linear effects.
}
