% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_evolution.R
\name{nsga2_set_user_params}
\alias{nsga2_set_user_params}
\title{Initialise analysis specific parameters for NSGA-2}
\usage{
nsga2_set_user_params(built_ensemble, parameters, measures,
  desiredResponses, sampleMins, sampleMaxes)
}
\arguments{
\item{built_ensemble}{Ensemble object that will be used in the NSGA-2
algorithm to generate predictions}

\item{parameters}{Names of simulation parameters for which values are input
to the  ensemble}

\item{measures}{Names of the simulation measures for which the ensemble
predicts}

\item{desiredResponses}{Vector of desired responses for the simulation
measures, used by the fitness function to determine goodness of fit for
evolved parameter sets}

\item{sampleMins}{Minimum value of the range of each parameter to be used
in evolving parameter sets}

\item{sampleMaxes}{Maximum value of the range of each parameter to be used
in evolving parameter sets}
}
\value{
List of the above objects for passing in as settings object to
NSGA-2 related methods
}
\description{
Creates an object of the analysis parameters that will be used to evolve
parameter sets or screen parameters for NSGA-2. The user should ensure this
is calle first, establishing this object such that it can be passed in to
the relevant method
}
