% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimcov.r
\name{estimcov}
\alias{estimcov}
\title{Estimation of simulation parameters}
\source{
\code{estimcov} uses code contributed by Roland Gerard Gera.
}
\usage{
estimcov(data, Time, Startvalues = c(3, 0.5, 1), stepwidth = c(0.001, 0.001,
  0.001), maxiter = 10000, lower = c(1e-04, 1e-04, 1e-04), upper = c(Inf,
  5, 3))
}
\arguments{
\item{data}{matrix with the dataset which is used to estimate the covariance and dropout structure.}

\item{Time}{vector with observation-times.}

\item{Startvalues}{vector with starting values for variance, \code{rho} and \code{theta} respectively.}

\item{stepwidth}{vector describing the step length of previously mentioned values.}

\item{maxiter}{maximum amount of iterations}

\item{lower}{vector with minimum for the parameters described in Startvalues}

\item{upper}{vector with maximum for the parameters described in Startvalues}
}
\value{
\code{estimcov} returns a list with two entries. In the first the parameters variance, \code{rho} and \code{theta} are returned and in the second a vector with the dropout-rate is returned.
}
\description{
\code{estimcov} estimates the covariance matrix and dropout rates given a dataset and observation-times
}
\details{
This function is designed to estimate the variance, \code{rho} and \code{theta} and a vector with the dropout rate in the data.
}
\examples{
# First generate a dataset with 200 patients, rho =0.25 and tau = 0.5 and
# then estimate the parameters using estimcov.

set.seed(2015)
dataset <- r.gee.1subgroup(n=200, reg=list(c(0,0,0,0.1),c(0,0,0,0.1)), sigma=c(3,2.5),
  tau=0.5, rho=0.25, theta=1, k=1.5, Time=c(0:5), OD=0)

estimations <- estimcov(data=dataset,Time=c(0:5))
estimations[[1]]
estimations[[2]]

}
