% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFunctions.R
\name{spathialStatistics}
\alias{spathialStatistics}
\title{Correlation}
\usage{
spathialStatistics(spathial_res)
}
\arguments{
\item{spathial_res}{principal path from the starting point to the ending point}
}
\value{
A list of objects
\itemize{
  \item correlations: Pearson's correlation coefficients between ea
  ch feature and the path (when ppath_perturbed is not NULL, a Fisher-integrated
  correlation coefficient is provided)
  \item ranks: ranks of associations between the n features and the path (when ppath_perturbed
  is not NULL, the mean of the ranks is provided)
  \item p_values: p values from the Pearson’s correlation scores
  \item p_adj: p values adjusted according to the Benjamini & Hochberg (BH) method
}
}
\description{
Get how much the features correlate with the path
}
\examples{
# Load data matrix X
load(system.file('extdata','X.rda',package='spathial',mustWork=TRUE))
# Load description vector X_labels
load(system.file('extdata','X_labels.rda',package='spathial',mustWork=TRUE))
# Run spathialBoundary
boundaryRes <- spathialBoundaryIds(X, X_labels, mode=2, from=3, to=6)
X <- boundaryRes$X
X_labels <- boundaryRes$X_labels
boundary_ids <- boundaryRes$boundary_ids
#Set the number of waypoints
NC <- 20
# Run spathialWay
spathial_res <- spathialWay(X, boundary_ids, NC)
#Run spathialStatistics with spathial_res
statistics <- spathialStatistics(spathial_res)
}
