% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_raster_header.R
\name{build_raster_header}
\alias{build_raster_header}
\title{Builds a raster header for a flat binary file.}
\usage{
build_raster_header(x_filename, reference_raster, out_nlayers,
  datatype = "FLT8S", format = "raster", bandorder = "BSQ",
  setMinMax = FALSE, additional_header = NULL, verbose = FALSE)
}
\arguments{
\item{x_filename}{Character. The filename of the input binary file.}

\item{reference_raster}{Raster*. A Raster* object containing the header information to be used.}

\item{out_nlayers}{Numeric. The number of layers in the flat binary file (defaults to nlayers(reference_raster)).}

\item{datatype}{Character. The dataType of the flat binary file.  See ?dataType for available datatypes.  Default is 'FLT8S'.}

\item{format}{Character. The format of the header.  See ?hdr for valid entries.  Default is 'raster'.  CURRENTLY UNSUPPORTED.}

\item{bandorder}{Character. The bandorder ('BIP','BIL','BSQ') of the file. Default is 'BSQ'.}

\item{setMinMax}{Logical. Set the min/max for the file (will take longer to execute)?  Default=FALSE.}

\item{additional_header}{Character. Create additional output headers for use with other GIS systems (see \code{\link{hdr}}). Set to NULL (default) to suppress.}

\item{verbose}{logical. Enable verbose execution? Default is FALSE.}
}
\description{
Builds a raster header for a flat binary file.
}
\examples{
\dontrun{ 
tahoe_highrez <- brick(system.file("external/tahoe_highrez.tif", package="spatial.tools"))
test_blank_file <- create_blank_raster(filename=paste(tempfile(),".gri",sep=""),
	reference_raster=tahoe_highrez,nlayers=2,
	create_header=FALSE,format="raster",datatype="FLT8S",bandorder="BSQ")
test_blank_raster <- build_raster_header(x_filename=test_blank_file,
	reference_raster=tahoe_highrez,out_nlayers=2,
	datatype='FLT8S',format='raster',bandorder="BSQ",setMinMax=TRUE)
test_blank_raster
}
}
\seealso{
\code{\link{hdr}},\code{\link{dataType}}
}
\author{
Jonathan A. Greenberg and Robert Hijimans (\email{spatial.tools@estarcion.net})
}
