% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialAtomizeR-package.R
\docType{package}
\name{spatialAtomizeR-package}
\alias{spatialAtomizeR-package}
\alias{spatialAtomizeR}
\title{spatialAtomizeR: Spatial Analysis with Misaligned Data Using Atom-Based Regression Models}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Implements atom-based regression models (ABRM) for analyzing spatially misaligned data. Provides functions for simulating misaligned spatial data, preparing NIMBLE model inputs, running MCMC diagnostics, and comparing different spatial analysis methods including dasymetric mapping. All main functions return S3 objects with print(), summary(), and plot() methods for intuitive result exploration. Methods are described in Nethery et al. (2023) \doi{10.1101/2023.01.10.23284410}. Further methodological details and software implementation are described in Qian et al. (in review).

Implements atom-based Bayesian regression methods (ABRM) for spatial data 
with misaligned grids.
}
\section{Main Functions}{

\describe{
  \item{\code{\link{simulate_misaligned_data}}}{Generate simulated spatial data}
  \item{\code{\link{get_abrm_model}}}{Get NIMBLE model code for ABRM}
  \item{\code{\link{run_abrm}}}{Run atom-based Bayesian regression model}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bellayqian/spatialAtomizeR}
  \item Report bugs at \url{https://github.com/bellayqian/spatialAtomizeR/issues}
}

}
\author{
\strong{Maintainer}: Yunzhe Qian \email{qyzanemos@gmail.com}

Authors:
\itemize{
  \item Rachel Nethery \email{rnethery@hsph.harvard.edu}
}

Other contributors:
\itemize{
  \item Nancy Krieger (Contributed to the project conceptualization and manuscript) [contributor]
  \item Nykesha Johnson (Contributed to the project conceptualization and manuscript) [contributor]
}

}
\keyword{internal}
