% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri.R
\name{tri}
\alias{tri}
\title{Terrain Ruggedness Index}
\usage{
tri(r, s = 3, exact = TRUE, file.name = NULL, ...)
}
\arguments{
\item{r}{raster class object}

\item{s}{Scale of window. Must be odd number, can represent 2 dimensions (eg., s=c(3,5) would represent a 3 x 5 window)}

\item{exact}{Calculate (TRUE/FALSE) the exact TRI or an algebraic approximation.}

\item{file.name}{Name of output raster (optional)}

\item{...}{Additional arguments passed to writeRaster}
}
\value{
raster class object or raster written to disk
}
\description{
Implementation of the Riley et al (1999) Terrain Ruggedness Index
}
\note{
The algebraic approximation is considerably faster. However, because inclusion of the center cell, the larger the scale the larger the divergence of the minimum value

Recommended ranges for classifying Topographic Ruggedness Index

0-80 (1) level terrain surface.

81-116 (2) nearly level surface.

117-161 (3) slightly rugged surface.

162-239 (4) intermediately rugged surface.

240-497 (5) oderately rugged surface.

498-958 (6) highly rugged surface.

>959 (7) extremely rugged surface.

Depends: raster
}
\examples{
 library(raster)
 r <- raster(nrows=180, ncols=360, xmn=571823.6, xmx=616763.6, ymn=4423540, 
             ymx=4453690, resolution=270, crs = CRS("+proj=utm +zone=12 +datum=NAD83 
             +units=m +no_defs +ellps=GRS80 +towgs84=0,0,0"))
   r[] <- runif(ncell(r), 1000, 5000) 
   r <- focal(r, w=matrix(1/121,nrow=11,ncol=11)) 
    
  ( tri.ext <- tri(r) )
  ( tri.app <- tri(r, exact = FALSE) )
  plot(stack(tri.ext, tri.app))

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
\references{
Riley, S.J., S.D. DeGloria and R. Elliot (1999) A terrain ruggedness index that quantifies topographic heterogeneity, Intermountain Journal of Sciences 5(1-4):23-27.
}

