% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.R
\name{background}
\alias{background}
\title{Background sample}
\usage{
background(
  x,
  ext = NULL,
  p = 1000,
  known = NULL,
  d = NULL,
  type = c("regular", "random", "hexagon", "nonaligned")
)
}
\arguments{
\item{x}{A polygon defining sample region}

\item{ext}{Vector of extent coordinates (xmin, xmax, ymin, ymax)}

\item{p}{Size of sample}

\item{known}{SpatialPoints of known locations (same CSR as x)}

\item{d}{Threshold distance for known proximity}

\item{type}{Type of sample c("systematic", "random", "hexagon", "nonaligned")}
}
\value{
A SpatialPointsDataFrame or data.frame with x,y coordinates
}
\description{
Creates a point sample that can be used as 
             a NULL for SDM's and other modeling approaches.
}
\note{
This function creates a background point sample based on an extent 
or polygon sampling region. The known argument can be used with d 
to remove sample points based on distance-based proximity to existing  
locations (eg., known species locations). The size (p) of the resulting 
sample will be dependent on the known locations and the influence of 
the distance threshold (d). As such, if the know and d arguments are
provided the exact value provided in p will not be returned.
}
\examples{
library(sp)
library(raster)
library(rgeos)
  data(meuse)
  coordinates(meuse) <- ~x+y

# create "known" locations  
locs <- meuse[sample(1:nrow(meuse), 5),]

# systematic sample using extent polygon
e <- as(extent(meuse), "SpatialPolygons")
s <- background(e, p=1000, known=locs, d=300)
  plot(s,pch=20)
    points(locs, pch=20, col="red")

# systematic sample using irregular polygon
data(meuse.grid)
  coordinates(meuse.grid) = c("x", "y")
  gridded(meuse.grid) = TRUE
meuse.poly = gUnaryUnion(as(meuse.grid, "SpatialPolygons"))

s <- background(meuse.poly, p=1000, known=locs, d=200)
  plot(s,pch=20)
    plot(meuse.poly, add=TRUE)
    points(locs, pch=20, col="red")

# random sample using irregular polygon
s <- background(meuse.poly, p=500, known=locs, 
                d=200, type="random")
  plot(s,pch=20)
    plot(meuse.poly, add=TRUE)
    points(locs, pch=20, col="red")

# systematic sample using defined extent
extent(meuse)
s <- background(ext=c(178605, 181390, 329714, 333611), 
                p=1000, known=locs, d=300)
  plot(s,pch=20)
    points(locs, pch=20, col="red")

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
