% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentration.R
\name{concentration}
\alias{concentration}
\title{Concentration risk}
\usage{
concentration(sub, full, value, lon_sub = lon, lat_sub = lat,
  lon_full = lon, lat_full = lat, radius = 200,
  display_progress = TRUE)
}
\arguments{
\item{sub}{data.frame of locations to calculate concentration risk for.}

\item{full}{data.frame to find the locations within radius \code{r} from locations in \code{sub}.}

\item{value}{Column with value in \code{full}.}

\item{lon_sub}{Column in \code{sub} with longitude (lon is default).}

\item{lat_sub}{Column in \code{sub} with latitude (lat is default).}

\item{lon_full}{Column in \code{full} with longitude in \code{full} (lon is default).}

\item{lat_full}{Column in \code{full} with latitude in \code{full} (lat is default).}

\item{radius}{Radius (in meters) (default is 200m).}

\item{display_progress}{Show progress bar (TRUE/FALSE).}
}
\value{
A data.frame equal to data.frame \code{sub} including an extra column \code{concentration}.
}
\description{
The sum of all observations within a radius from center point(s). In particular,
it can be used to determine concentration risk in the context of the EU insurance regulation framework (Solvency II).
The function offers an effective approach to calculate the 'standard formula' under Solvency II.
The 'standard formula' under Solvency II asks companies to report their largest fire concentration in
respect of the fire peril within a radius of 200m. This is the maximum gross sum insured of the set of
buildings fully or partly located within this radius (Commission Delegated Regulation (EU), 2015, Article 132).
}
\details{
The data.frame \code{sub} should include at least columns for longitude and latitude.

The data.frame \code{full} should include at least columns for longitude, latitude and value of interest to summarize.
}
\examples{
df <- data.frame(location = c("p1", "p2"), lon = c(6.561561, 6.561398), lat = c(53.21369, 53.21326))
concentration(df, Groningen, value = amount, radius = 100)

}
\references{
Commission Delegated Regulation (EU) (2015). Solvency II Delegated Act 2015/35. Official Journal of the European Union, 58:124.
}
\author{
Martin Haringa
}
