% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_clustering_cv.R
\name{spatial_clustering_cv}
\alias{spatial_clustering_cv}
\title{Spatial or Cluster Cross-Validation}
\usage{
spatial_clustering_cv(
  data,
  coords,
  v = 10,
  cluster_function = c("kmeans", "hclust"),
  radius = NULL,
  buffer = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame or an \code{sf} object (often from \code{\link[sf:st_read]{sf::read_sf()}}
or \code{\link[sf:st_as_sf]{sf::st_as_sf()}}), to split into folds.}

\item{coords}{A vector of variable names, typically spatial coordinates,
to partition the data into disjointed sets via k-means clustering.
This argument is ignored (with a warning) if \code{data} is an \code{sf} object.}

\item{v}{The number of partitions of the data set.}

\item{cluster_function}{Which function should be used for clustering?
Options are either \code{"kmeans"} (to use \code{\link[stats:kmeans]{stats::kmeans()}})
or \code{"hclust"} (to use \code{\link[stats:hclust]{stats::hclust()}}). You can also provide your own
function; see \code{Details}.}

\item{radius}{Numeric: points within this distance of the initially-selected
test points will be assigned to the assessment set. If \code{NULL}, no radius is
applied.}

\item{buffer}{Numeric: points within this distance of any point in the
test set (after \code{radius} is applied) will be assigned to neither the analysis
or assessment set. If \code{NULL}, no buffer is applied.}

\item{...}{Extra arguments passed on to \code{\link[stats:kmeans]{stats::kmeans()}} or
\code{\link[stats:hclust]{stats::hclust()}}.}
}
\value{
A tibble with classes \code{spatial_clustering_cv}, \code{spatial_rset},
\code{rset}, \code{tbl_df}, \code{tbl}, and \code{data.frame}.
The results include a column for the data split objects and
an identification variable \code{id}.
Resamples created from non-\code{sf} objects will not have the
\code{spatial_rset} class.
}
\description{
Spatial or cluster cross-validation splits the data into V groups of
disjointed sets using k-means clustering of some variables, typically
spatial coordinates. A resample of the analysis data consists of V-1 of the
folds/clusters while the assessment set contains the final fold/cluster. In
basic spatial cross-validation (i.e. no repeats), the number of resamples
is equal to V.
}
\details{
The variables in the \code{coords} argument are used for k-means clustering of
the data into disjointed sets, as outlined in Brenning (2012), or for
hierarchical clustering of the data. These
clusters are used as the folds for cross-validation. Depending on how the
data are distributed spatially, there may not be an equal number of points
in each fold.

You can optionally provide a custom function to \code{cluster_function}. The
function must take three arguments:
\itemize{
\item \code{dists}, a \code{\link[stats:dist]{stats::dist()}} object with distances between data points
\item \code{v}, a length-1 numeric for the number of folds to create
\item \code{...}, to pass any additional named arguments to your function
}

The function should return a vector of cluster assignments of length
\code{nrow(data)}, with each element of the vector corresponding to the matching
row of the data frame.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Smithsonian, package = "modeldata")
spatial_clustering_cv(Smithsonian, coords = c(latitude, longitude), v = 5)

smithsonian_sf <- sf::st_as_sf(
  Smithsonian,
  coords = c("longitude", "latitude"),
  # Set CRS to WGS84
  crs = 4326
)

# When providing sf objects, coords are inferred automatically
spatial_clustering_cv(smithsonian_sf, v = 5)

# Can use hclust instead:
spatial_clustering_cv(smithsonian_sf, v = 5, cluster_function = "hclust")
\dontshow{\}) # examplesIf}
}
\references{
A. Brenning, "Spatial cross-validation and bootstrap for the assessment of
prediction rules in remote sensing: The R package sperrorest," 2012 IEEE
International Geoscience and Remote Sensing Symposium, Munich, 2012,
pp. 5372-5375, doi: 10.1109/IGARSS.2012.6352393.
}
