% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_spectral_indic_methods.R
\name{plot_spectrum}
\alias{plot_spectrum}
\title{Display the r-spectrum of a \code{spectral_sews} object}
\usage{
plot_spectrum(x, along = NULL, log = TRUE, display_null = TRUE, ...)
}
\arguments{
\item{x}{An object produced by \code{\link{spectral_sews}} or the result 
returned by \code{\link{indictest}} applied on such object}

\item{along}{A vector providing numerical or categorical values along 
which the indicator trends will be plotted. If \code{NULL} then the
indicator values are plotted sequentially in their original order.}

\item{log}{Whether to use a log scale or a linear scale on the y axis}

\item{display_null}{Whether to display null information. This argument is 
ignored if \code{x} has not been produced through \code{\link{indictest}} 
(and thus does not contain data regarding the null model)}

\item{...}{Other arguments are ignored}
}
\description{
Display the r-spectrum (or multiple spectra) that are contained
  in an object returned by \code{\link{spectral_sews}} object (or the result 
  of \code{\link{indictest}} applied on such object.
}
\seealso{
\code{\link{rspectrum}}, \code{\link{spectral_sews}}, 
  \code{\link{extract_spectrum}}
}
