% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptable.r
\name{sptable}
\alias{sptable}
\alias{sptable.SpatialLinesDataFrame}
\alias{sptable.SpatialMultiPointsDataFrame}
\alias{sptable.SpatialPointsDataFrame}
\alias{sptable.SpatialPolygonsDataFrame}
\alias{sptable<-}
\title{Convert from Spatial*DataFrame to table.}
\usage{
sptable(x, ...)

\method{sptable}{SpatialPolygonsDataFrame}(x, ...)

\method{sptable}{SpatialLinesDataFrame}(x, ...)

\method{sptable}{SpatialPointsDataFrame}(x, ...)

\method{sptable}{SpatialMultiPointsDataFrame}(x, ...)

sptable(object) <- value
}
\arguments{
\item{x}{\code{\link[sp]{Spatial}} object}

\item{...}{ignored

For simplicity \code{sptable} and its inverse \code{sp} assume that all geometry can be encoded with object, branch, island, order, x and y. 
and that the type of topology is identified by which of these are present.}

\item{object}{Spatial object}

\item{value}{modified sptable version of object}
}
\value{
\code{\link[dplyr]{tbl_df}} data_frame with columns
\itemize{
 \item SpatialPolygonsDataFrame "object_"   "branch_"   "island_"   "order_" "x"    "y_"
 \item SpatialLinesDataFrame "object_"   "branch_" "order_"  "x_"      "y_"
 \item SpatialPointsDataFrame  "object_" x_"      "y_"
 \item SpatialMultiPointsDataFrame "object_" "branch_" "x_" "y_"
}

Spatial object
}
\description{
Decompose a Spatial object to a single table structured as a row for every coordinate in all the sub-geometries, including duplicated coordinates that close polygonal rings, close lines and shared vertices between objects.
}
\details{
Input can be a \code{\link[sp]{SpatialPolygonsDataFrame}}, \code{\link[sp]{SpatialLinesDataFrame}} or a \code{\link[sp]{SpatialPointsDataFrame}}.
}

