% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Methods_For_Class.R
\name{compare.spca}
\alias{compare}
\alias{compare.spca}
\title{Compares two or more spca solutions}
\usage{
\method{compare}{spca}(smpc, compareto, nd, methodsnames, perc = TRUE,
  plotvar = TRUE, plotload = FALSE, labelload = TRUE,
  sizelabelsload = 0.85, poslabeload = 3, prnload = TRUE,
  shortnamescomp = TRUE, rtn = FALSE, prn = TRUE, only.nonzero = TRUE,
  bnw = FALSE, mfrowload = 1, mfcolload = 1, sizelegend = 0.85, ...)

compare(smpc, ...)
}
\arguments{
\item{smpc}{An spca object}

\item{compareto}{A list of spca objects with which smpc is to be compared. Can be givenas
single object}

\item{nd}{Number of dimensions to compare. If not specified set to the
minimum number of loadings in the objects.}

\item{methodsnames}{Names for each object included. If not specified, labels are
created as Met1, Met2, etc.}

\item{perc}{Logical: should the loadings be standardised to unit \eqn{L_1}
norm (and printed as percentage contributions).}

\item{plotvar}{Logical: should the cumulative variances be plotted?}

\item{plotload}{Logical or integer (>0): should the loadings be plotted and
how many?}

\item{labelload}{Logical: write variables names loading plots?}

\item{sizelabelsload}{Real: expansion coefficient for loading plot label.
See \emph{cex} in \code{\link[graphics]{par}},}

\item{poslabeload}{integer: position of the labels of the laodings.
1 = bottom, 2 = left, 3 = top (default), 4 = right.}

\item{prnload}{Logical or Integer (>0): should the loadings be printed and
how many?}

\item{shortnamescomp}{Logical: should the loadings be printed with short names
(Cx.y) or long ones (Cx.methodsnames)?}

\item{rtn}{Logical: should the text table of loadings and the matrix of
summaries be returneded?}

\item{prn}{Logical: should anything be printed? Takes priority on prnload.}

\item{only.nonzero}{Logical: should only nonzero contributions be printed?}

\item{bnw}{Logical: should plots be in blck and white?}

\item{mfrowload}{Number of loadings plots per row.}

\item{mfcolload}{Number of loadings plots per column.}

\item{sizelegend}{Magnification of the legend labels, see \emph{cex} in
\code{\link[graphics]{par}}.}

\item{...}{additional arguments for generic compare. Disabled, additional arguments will
generate an error.}
}
\value{
If rtn = TRUE, it returns a formatted text table with the loadings
and a matrix with the summaries.

\code{NULL}
}
\description{
Compares two or more spca solutions by printing the loadings and the summary
statistics next to each other. It can plot the cumulative variances
explained together with those of PCA and the loadings for each component.
}
\details{
For the meaning of each summary statistic see \code{\link{summary.spca}}.  Plotvar
plots \emph{nd} values. if \emph{plotload} or \emph{prnload} are integer,
that number of loaidngs will be processed. However, \emph{nd}
loadings are always returned if \emph{rtn=TRUE}.
}
\seealso{
Examples in \code{\link{spcabb}} and \code{\link{spcabe}}.
}

