% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Methods_For_Class.R
\name{print.spca}
\alias{print.spca}
\title{Prints the sparse loadings from an spca object}
\usage{
\method{print}{spca}(x, cols, only.nonzero = TRUE, perc = TRUE,
  digits = 3, thresh = 0.001, rtn = FALSE, namescomp = NULL, ...)
}
\arguments{
\item{x}{An spca object.}

\item{cols}{A vector indicating which components should be printed. Default
all. If an iteger is passed, it is set to 1:cols.}

\item{only.nonzero}{Logical: if = TRUE only the nonzero loadings are printed.
otherwise all loadings are printed.}

\item{perc}{Logical: should the loadings be standardised to unit \eqn{L_1}
norm (and printed as percentage contributions)?}

\item{digits}{Integer: number of decimal figures.}

\item{thresh}{Value below which loadings are considered zero and not
printed.}

\item{rtn}{Logical: should the formatted (text) table be returned?}

\item{namescomp}{A vector of names for the components. If NULL assigned as
"Comp j"}

\item{...}{Additonal arguments for generic print, additional arguments will
generate an error.}
}
\value{
If rtn = TRUE, it returns a text table formatted as specified by the
arguments.
}
\description{
Prints sparse loadings omitting the zero ones and giving the cumulative
variance explained.
}
\note{
This is a wrapper for the main function in which the "dots" are disabled
so that only exact (or partial) prescribed arguments can be entered.
}
\seealso{
Examples in \link{spcabb} and \link{spcabe}.
}

