% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{SPC2sidedconfint}
\alias{SPC2sidedconfint}
\title{Computes a two-sided confidence interval for properties of a control chart.}
\usage{
SPC2sidedconfint(covprob = 0.9, ...)
}
\arguments{
\item{covprob}{The coverage probability of the adjustment.}

\item{...}{Parameters to be passed to SPCproperty}
}
\value{
The desired confidence interval, a vector of length 2.
}
\description{
Computes a two-sided confidence interval for properties of a control chart.
}
\examples{
# Compute 2-sided CI for the ARL of a CUSUM control chart assuming normality.
 X <-  rnorm(100) #observed data
 chart <- new("SPCCUSUM",model=SPCModelNormal(Delta=1)) # CUSUM chart with normal observations
 SPC2sidedconfint(data=X,nrep=100,covprob=0.95,
            property="ARL",chart=chart,params=list(threshold=4))

}
\seealso{
\code{\link{SPCproperty}}
}

