% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeakFilling.R
\name{PeakFilling}
\alias{PeakFilling}
\title{Peak filling of any missed peaks}
\usage{
PeakFilling(Y.aligned, Y.spec, max.index.shift = 10, window.width = "small",
  nCPU = -1)
}
\arguments{
\item{Y.aligned}{Aligned peaks (after the 'PeakAligner' function).}

\item{Y.spec}{The raw NMR spectra in matrix format.}

\item{max.index.shift}{Maximal shift in index between a filled peak and the group it belongs to.}

\item{window.width}{The width of the detection window for the wavelets. Because of the Fourier transform lengths of 512 ( window.width = 'small') of 1024 ( window.width = 'large') are preferable.}

\item{nCPU}{The amount of cpu's to be used for peak detection. If set to '-1' all available cores minus 1 will be used.}
}
\value{
Returns a data frame with aligned peaks and possibly extra peaks obtained from the raw data (these peaks have SNR = NA).
}
\description{
This functions detects which samples (after alignment) are missing from every aligned peak group and reanalyses the raw data to verify whether this peak is actually non-existent for this sample
}
\examples{
\dontrun{
# This function works on a data frame resulting from the 'PeakAligner' function 
# DetectedPeaks <- getWaveletPeaks(X.ppm= PPM.vector, Y=Y.spec,  baselineThresh = 10,nCPU  = 4)
# Aligned.peaks = PeakAligner = function (Y.peaks = DetectedPeaks)
Filled.Peaks = SpecPeak.filling(Y.aligned = Aligned.peaks, Y.spec = Y)
}

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}

