% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotRMSE}
\alias{plotRMSE}
\title{Plots RMSE across model specifications.}
\usage{
plotRMSE(sca_data, title = "", showIndex = TRUE, plotVars = TRUE)
}
\arguments{
\item{sca_data}{A data frame returned by `sca()` containing model estimates
from the specification curve analysis.}

\item{title}{A string to use as the plot title. Defaults to an empty string,
`""`.}

\item{showIndex}{A boolean indicating whether to label the model index on the
the x-axis. Defaults to `TRUE`.}

\item{plotVars}{A boolean indicating whether to include a panel on the plot
showing which variables are present in each model. Defaults
to `TRUE`.}
}
\value{
If `plotVars = TRUE` returns a grid grob (i.e. the output of a call
        to `grid.draw`). If `plotVars =  FALSE` returns a ggplot object.
}
\description{
plotRMSE() plots the root mean square error across model specifications. Only
available for linear regression models.
}
\examples{
plotRMSE(sca_data = sca(y="Salnty", x="T_degC", c("ChlorA", "O2Sat"),
                         data=bottles, progressBar=TRUE, parallel=FALSE),
                     title = "RMSE");
plotRMSE(sca_data = sca(y="Salnty", x="T_degC", c("ChlorA*O2Sat"),
                         data=bottles, progressBar=FALSE, parallel=FALSE),
                     showIndex = FALSE, plotVars = FALSE);
plotRMSE(sca_data = sca(y="Salnty", x="T_degC",
                         c("ChlorA*NO3uM", "O2Sat*NO3uM"), data=bottles,
                         progressBar = TRUE, parallel=TRUE, workers=2));
}
