% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{logboxplot}
\alias{logboxplot}
\title{Log boxplot based for outlier detection.}
\usage{
logboxplot(data, var, output, x = 1.5, pc = FALSE, pcvar = NULL, boot = FALSE)
}
\arguments{
\item{data}{Dataframe or vector where to check outliers.}

\item{var}{Variable to be used for outlier detection if \strong{data} is not in a vector format.}

\item{output}{Either \strong{clean}: for clean data output without outliers; \strong{outliers}:
for outlier data frame or vectors.}

\item{x}{The constant for creating lower and upper fences. Extreme is 3, but default is 1.5.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}
}
\value{
Dataframe with our without outliers depending on the output.
\describe{
\item{clean}{Data without outliers.}
\item{outlier}{Data with outliers.}
}
}
\description{
Log boxplot based for outlier detection.
}
\details{
The loxplot for outlier detection \strong{Barbato et al. (2011)} modifies the
the interquartile range method to detect outlier but considering the sample sizes while indicating
the fences (lower and upper fences).

\deqn{ lowerfence = [Q1 -1.5*IQR[1+0.1 * log(n/10)]}

\deqn{upperfence = [Q3 +1.5*IQR[1+0.1 *log(n/10)]}

     Where; Q1 is the lower quantile and Q3 is the upper quantile. The method consider the sample
     size in setting the fences, to address the weakness of the interquartile range method \emph{(Tukey, 1977)}.
     However. similar to IQR method for flagging outlier, log boxplot modification is affected by
     data skewness and which can be address using
      \link[specleanr]{distboxplot},  \code{\link{seqfences}}, \code{\link{mixediqr}} and
     \code{\link{semiIQR}}.
}
\examples{
\donttest{
data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                        lat = 'decimalLatitude', lon= 'decimalLongitude',
                          colsp = "scientificName",
                          bbox = db,
                          minpts = 10)

 logout <- logboxplot(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')

}

}
\references{
Barbato G, Barini EM, Genta G, Levi R. 2011. Features and performance of
some outlier detection methods. Journal of Applied Statistics 38:2133-2149
}
