% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{zscore}
\alias{zscore}
\title{Computes z-scores to flag environmental outliers.}
\usage{
zscore(
  data,
  var,
  output = "outlier",
  type = "mild",
  mode = "soft",
  pc = FALSE,
  pcvar = NULL,
  boot = FALSE
)
}
\arguments{
\item{data}{Dataframe or vector to check for outliers.}

\item{var}{Variable considered in flagging suspicious outliers.}

\item{output}{Either \strong{clean}: for data frame with no suspicious outliers or outlier: to return dataframe with only outliers.}

\item{type}{Either \strong{mild} if zscore cut off is 2.5 or \strong{extreme} if zscore is >3.}

\item{mode}{Either robust, if a \strong{robust} mode is used which uses median instead of
mean and median absolute deviation from median.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}
}
\value{
Data frame with or with no outliers.
}
\description{
Computes z-scores to flag environmental outliers.
}
\details{
The method uses mean as an estimator of location and standard deviation for scale
    \code{(Rousseeuw & Hubert 2011)}, which both have zero breakdown point,
    and their influence function is unbounded (robustness of an estimator to outliers)
    \code{(Seo 2006; Rousseeuw & Hubert 2011)}. Because both parameters are not
    robust to outliers, it leads to outlier masking and swamping
    \code{(Rousseeuw & Hubert 2011)}. Records are flagged as outliers
    if their Z-score exceeds 2.5 \code{(Rousseeuw & Hubert 2011)}.
}
\examples{

\donttest{
data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                          lat = 'decimalLatitude', lon= 'decimalLongitude',
                          colsp = "scientificName",
                          bbox = db,
                          minpts = 10)

 zout <- zscore(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')
}

}
