% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R
\name{Spectra}
\alias{Spectra}
\title{Constructor for the Spectra class.}
\usage{
Spectra(wl = numeric(), nir = matrix(), id = as.character(NA),
  units = "nm")
}
\arguments{
\item{wl}{a numeric vector giving the wavelengths at with the spectra have
been measured}

\item{nir}{a \code{"matrix"} or a \code{"data.frame"} object giving the
spectra values for each sample}

\item{id}{a vector giving the unique id of each sample in the collection}

\item{units}{a character giving the unit in which the wavelengths values are
expressed}
}
\value{
a new \code{"Spectra"} object
}
\description{
Constructor for the Spectra class. Creates a Spectra object from scratch.
}
\examples{

  wls <- 350:2500
  id <- c("A", "B")
  nir <- matrix(runif(2*length(wls)), nrow = 2)
  s <- Spectra(wl = wls, nir = nir, id = id, units = "nm")

}
\seealso{
\code{spectra}, \code{wl},
\code{Spectra-class}, \code{SpectraDataFrame}
}
\author{
Pierre Roudier \email{pierre.roudier@gmail.com}
}
