% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{subset_by}
\alias{subset_by}
\alias{subset_by.spectra}
\title{Subset spectra by factor}
\usage{
subset_by(x, by, n_min, n_max, random = TRUE)

\method{subset_by}{spectra}(x, by, n_min, n_max, random = TRUE)
}
\arguments{
\item{x}{spectra object}

\item{by}{vector coercible to factor and of same length as nrow(x)}

\item{n_min}{int. only keep spectra with at least (inclusive) `n_min` number
of samples per unique `by`.}

\item{n_max}{int. keep at most (incl) this number of spectra per unique `by`}

\item{random}{boolean. Sample randomly or keep first n_max? Defaults to TRUE}
}
\value{
spectra
}
\description{
\code{subset_by} subsets spectra by a factor `by` ensuring that it appears at
most `n_max` times **and** at least `n_min` times in the dataset.
}
\details{
Note that \code{subset_by} forces you to provide both a minimum and a maximum
number of spectra to be kept for each unique value of `by`. In case you're
interested in subsetting \emph{only} based on `n_min`, set `n_max` to `Inf`.
}
\section{Methods (by class)}{
\itemize{
\item \code{spectra}: Subset spectra by factor
}}

\examples{
library(spectrolab)
spec = as_spectra(spec_matrix_example, name_idx = 1)

# remove spec of species with less than 4 samples
spec = subset_by(spec, by = names(spec), n_min = 4, n_max = Inf)
}
\author{
Jose Eduardo Meireles
}
