% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{aggregate.spectra}
\alias{aggregate.spectra}
\title{Aggregate spectra}
\usage{
\method{aggregate}{spectra}(x, by, FUN, FUN_meta = NULL, ...)
}
\arguments{
\item{x}{spectra object}

\item{by}{vector of factors to guide the aggregation}

\item{FUN}{function to be applied to refl (and meta if FUN_meta is NULL)}

\item{FUN_meta}{function to be applied to metadata. If NULL (default), same
FUN applied to reflectance is used.}

\item{...}{extra args to FUN}
}
\value{
spectra object
}
\description{
Applies FUN (and FUN_meta) over spectra aggregating by factor `by`.
}
\details{
Argument FUN_meta is useful if you want to apply a different function to
metadata and reflectance. If you want to aggregate spectra and metadata
using `mean`, `sd`, `median` etc. but try to keep the text values, wrap your
function in \code{try_keep_txt(f)}.
}
\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example)
spec_mean = aggregate(spec, by = names(spec), mean, try_keep_txt(mean))
}
\author{
Jose Eduardo Meireles
}
