/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.FocusAwareComponent;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class MouseFocusObserver
implements DockRelocatorListener {
    private List<FocusVetoListener> vetos = new ArrayList<FocusVetoListener>();
    private DockController controller;

    public MouseFocusObserver(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        this.controller = dockController;
        controllerSetupCollection.add(new ControllerSetupListener(){

            public void done(DockController dockController) {
                dockController.getRelocator().addDockRelocatorListener(MouseFocusObserver.this);
            }
        });
    }

    public void kill() {
        this.getController().getRelocator().removeDockRelocatorListener(this);
    }

    public DockController getController() {
        return this.controller;
    }

    public void addVetoListener(FocusVetoListener focusVetoListener) {
        this.vetos.add(focusVetoListener);
    }

    public void removeVetoListener(FocusVetoListener focusVetoListener) {
        this.vetos.remove(focusVetoListener);
    }

    protected FocusVetoListener.FocusVeto fireVetoTitle(DockTitle dockTitle) {
        for (FocusVetoListener focusVetoListener : this.vetos.toArray(new FocusVetoListener[this.vetos.size()])) {
            FocusVetoListener.FocusVeto focusVeto = focusVetoListener.vetoFocus(this, dockTitle);
            if (focusVeto == FocusVetoListener.FocusVeto.NONE) continue;
            return focusVeto;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    protected FocusVetoListener.FocusVeto fireVetoDockable(Dockable dockable) {
        for (FocusVetoListener focusVetoListener : this.vetos.toArray(new FocusVetoListener[this.vetos.size()])) {
            FocusVetoListener.FocusVeto focusVeto = focusVetoListener.vetoFocus(this, dockable);
            if (focusVeto == FocusVetoListener.FocusVeto.NONE) continue;
            return focusVeto;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    protected void check(AWTEvent aWTEvent) {
        if (this.controller.getRelocator().isOnPut() || this.controller.isOnFocusing()) {
            return;
        }
        Object object = aWTEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            if (aWTEvent.getID() == 501) {
                if (component.isFocusable() && component.isEnabled()) {
                    this.check(component, false, true, aWTEvent);
                } else {
                    this.check(component, true, false, aWTEvent);
                }
            } else {
                this.check(component, aWTEvent);
            }
        }
    }

    protected boolean interact(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        return n == 501 || n == 507;
    }

    protected void handleVeto(AWTEvent aWTEvent, FocusVetoListener.FocusVeto focusVeto) {
        if (focusVeto == FocusVetoListener.FocusVeto.VETO && aWTEvent instanceof InputEvent) {
            ((InputEvent)aWTEvent).consume();
        }
    }

    protected void check(Component component, AWTEvent aWTEvent) {
        this.check(component, true, false, aWTEvent);
    }

    protected void check(final Component component, final boolean bl, boolean bl2, final AWTEvent aWTEvent) {
        Dockable dockable = this.getDockable(component, aWTEvent);
        if (dockable != null) {
            Dockable dockable2 = this.controller.getFocusedDockable();
            boolean bl3 = true;
            if (dockable2 != null) {
                boolean bl4 = bl3 = !DockUtilities.isAncestor(dockable, dockable2);
            }
            if (bl3) {
                if (component instanceof FocusAwareComponent) {
                    FocusAwareComponent focusAwareComponent = (FocusAwareComponent)((Object)component);
                    if (bl2) {
                        focusAwareComponent.maybeRequestFocus();
                    }
                    focusAwareComponent.invokeOnFocusRequest(new Runnable(){

                        public void run() {
                            Dockable dockable = MouseFocusObserver.this.getDockable(component, aWTEvent);
                            if (dockable != null) {
                                MouseFocusObserver.this.controller.setFocusedDockable(dockable, false, bl);
                            }
                        }
                    });
                } else {
                    if (bl2) {
                        component.requestFocusInWindow();
                    }
                    this.controller.setFocusedDockable(dockable, false, bl);
                }
            }
        }
    }

    public void init(DockController dockController, Dockable dockable) {
    }

    public void cancel(DockController dockController, Dockable dockable) {
    }

    public void drag(DockController dockController, Dockable dockable, DockStation dockStation) {
    }

    public void drop(final DockController dockController, final Dockable dockable, DockStation dockStation) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                dockController.setFocusedDockable(dockable, true);
            }
        });
    }

    protected Dockable getDockable(Component component, AWTEvent aWTEvent) {
        DockElementRepresentative dockElementRepresentative = this.controller.searchElement(component);
        if (dockElementRepresentative == null) {
            return null;
        }
        Dockable dockable = dockElementRepresentative.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        FocusVetoListener.FocusVeto focusVeto = dockElementRepresentative instanceof DockTitle ? this.fireVetoTitle((DockTitle)dockElementRepresentative) : this.fireVetoDockable(dockable);
        if (focusVeto != FocusVetoListener.FocusVeto.NONE) {
            this.handleVeto(aWTEvent, focusVeto);
            return null;
        }
        return dockable;
    }
}

